package com.clx.performance.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.model.OrderGoodsTruckBind;
import com.clx.performance.param.pc.OrderGoodsEditParams;
import com.clx.performance.param.pc.PageOrderGoodsListParam;
import com.clx.performance.mapper.OrderGoodsMapper;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.param.app.OrderGoodsListPageParam;
import com.clx.performance.param.pc.GoodsOrderMapParam;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
public interface OrderGoodsDao extends BaseDao<OrderGoodsMapper, OrderGoods, Integer> {
    boolean updateWeight(@Param("orderId")Integer orderId, @Param("weight") BigDecimal weight);

    String getMaxOrderGoodsId();

    Optional<OrderGoods> getByOrderGoodsNo(String orderGoodsNo);

    Optional<OrderGoods> getOrderGoodsInfoByOrderGoodsNoForPC(String orderGoodsNo);

    Optional<OrderGoods> getOrderGoodsInfoByOrderGoodsNoForAPP(String orderGoodsNo);


    IPage<OrderGoodsVO> pageOrderGoodsList(PageOrderGoodsListParam param);

    void updateOrderGoodsReduceWeightAndStatus(Integer id, BigDecimal orderChildWeight, Integer orderGoodsStatus);

    void updateOrderGoodsWeightResidueAndAlreadyAndStatus(Integer id, BigDecimal alreadyTransportWeight,BigDecimal residueTransportWeight,Integer orderGoodsStatus);

    IPage<OrderGoodsAPPVO> openOrderPageGoodsList(OrderGoodsListPageParam orderGoodsListPageParam);

    IPage<OrderGoodsAPPVO> exclusiveOrderPageGoodsList(OrderGoodsListPageParam orderGoodsListPageParam, List<String> orderGoodsNoList);

    void updateOrderGoodsStatusByOrderGoodsNo(String orderGoodsNo, Integer code);

    void saveBatchEntity(List<OrderGoods> orderGoodsList);

    List<OrderGoods> getOrderGoodsListByOrderNo(String orderNo);

    List<OrderGoods> getOrderGoodsListByOrderNoAndLastArriveSendTime(String orderNo, LocalDateTime lastArriveSendTime);

    Optional<List<OrderGoods>> getOrderGoodsList();

    List<OrderGoods> getSendAddressSelect(GoodsOrderMapParam param);

    List<OrderGoods> listIntegralOrderGoodsSync();

    boolean updatePendingOrderFreightById(Integer id, BigDecimal pendingOrderFreight);

    Boolean updateStopFlagByOrderNo(String orderNo, Integer stopFlag);

    boolean updateOrderGoodsStatusAndRollbackResidueWeightByOrderGoodsNo(Integer orderGoodsId, Integer status);

    Integer updateOrderGoodsSetAlreadyWeight(BigDecimal alreadyWeight,  Integer id);

    Integer updateOrderGoodsSetResidueWeightAndAlreadyWeight(BigDecimal residueWeight, BigDecimal alreadyWeight, Integer id);

    Integer updateOrderGoodsSetResidueWeightAndAlreadyWeightAndStatus(BigDecimal residueWeight, BigDecimal alreadyWeight, Integer status, Integer id);


    OrderGoodsVO findOrderGoodsById(Integer id);

    List<OrderGoods> selectListByOrderGoodsList(List<String> orderGoodsNo);

    Integer updateOrderGoods(OrderGoodsEditParams orderGoodsEditParams);

    boolean batchUpdateOrderGoodsStatus(Integer status, List<Integer> ids);

    boolean batchUpdateOrderGoodsWeight(BigDecimal residueWeight, List<Integer> ids);

    List<OrderGoods> getOrderGoodsListByOrderNoAndStatus(String orderNo);

    List<OrderGoodsAPPVO> getCancelOrderGoods(List<OrderGoodsTruckBind> list);
}
