package com.clx.performance.vo.pc.vehiclewarn;

import com.clx.performance.enums.vehiclewarn.VehicleWarnRangEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Objects;

/**
* @Author: aiqinguo
* @Description: 预警范围
* @Date: 2024/06/04 18:49:39
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
public class VehicleWarnRangDTO {

    @Schema(description = "id", example = "1")
    private Integer id;
    @Schema(description = "预警配置id", example = "1")
    private Integer warnConfigId;
    @Schema(description = "预警名称", example = "运单预警")
    private String warnName;
    @Schema(description = "预警屏蔽范围：1运单 2货单 3全部", example = "1")
    private Integer warnRang;
    @Schema(description = "预警屏蔽范围：1运单 2货单 3全部", example = "1")
    private String warnRangMsg;
    public String getWarnRangMsg() {
        return VehicleWarnRangEnum.WarnRange.getMsgByCode(warnRang);
    }
    @Schema(description = "货单编号", example = "10000")
    private String orderGoodsNo;
    @Schema(description = "运单编号", example = "10001")
    private String childNo;

    @Schema(description = "暂停对象", example = "10001")
    private String suspendObject;
    public String getSuspendObject() {
        if (Objects.equals(warnRang, VehicleWarnRangEnum.WarnRange.CHILD.getCode())) {return childNo;}
        if (Objects.equals(warnRang, VehicleWarnRangEnum.WarnRange.ORDER_GOODS.getCode())) {return orderGoodsNo;}
        return "";
    }

    @Schema(description = "预警屏蔽结束时间", example = "")
    private String warnEndTime;
    @Schema(description = "状态：1有效 2无效", example = "")
    private Integer status;
    @Schema(description = "创建人", example = "")
    private String createBy;
    @Schema(description = "创建时间", example = "")
    private String createTime;
    @Schema(description = "操作时间", example = "")
    private String modifiedTime;

}