package com.clx.performance.vo.pc.owner.settle;

import com.clx.performance.enums.settle.SettlementOwnerEnum;
import com.clx.performance.enums.settle.SettlementWayEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @ClassName CarrierPageSettlementOwnerDetailVO
 * @Description
 * @Author kavin
 * @Date 2023/10/16 15:01
 * @Version 1.0
 */
@Getter
@Setter
public class OwnerPageSettlementOwnerVO {
    @Schema(description = "结算单Id")
    private Integer id;
    @Schema(description = "结算单号")
    private String settlementNo;
    @Schema(description = "开票标识：1网运单 2普通单")
    private Integer invoiceType;
    private String invoiceTypeMsg;
    public String getInvoiceTypeMsg() {
        return SettlementOwnerEnum.InvoiceType.getMsgByCode(invoiceType);
    }

    @Schema(description = "货主编码")
    private Long ownerUserNo;
    @Schema(description = "货主姓名")
    private String ownerName;
    @Schema(description = "订单编号")
    private String orderNo;
    @Schema(description = "实际净重（吨）")
    private BigDecimal weight;
    @MoneyOutConvert
    @Schema(description = "实际运费金额")
    private BigDecimal freight;
    @MoneyOutConvert
    @Schema(description = "预付运费金额")
    private BigDecimal prepayFreight;
    @Schema(description = "货损吨数（吨）")
    private BigDecimal lossWeight;
    @MoneyOutConvert
    @Schema(description = "货损金额")
    private BigDecimal lossFreight;
    @MoneyOutConvert
    @Schema(description = "借款金额")
    private BigDecimal loanFreight;
    @MoneyOutConvert
    @Schema(description = "结算金额")
    private BigDecimal settlementFreight;
    @MoneyOutConvert
    @Schema(description = "开票金额")
    private BigDecimal invoiceFreight;
    @MoneyOutConvert
    @Schema(description = "开票服务费")
    private BigDecimal invoiceServiceFee;
    @Schema(description = "创建时间")
    private String createTime;
    @Schema(description = "状态 10:待锁定  20:待对账  30:待货主确认 40:待货主付款 50:待平台确认付款 60:待平台付款 70:待货主确认付款 80:待邮寄发票 90:已完结")
    private Integer status;
    private String statusMsg;
    public String getStatusMsg() {
        return SettlementOwnerEnum.Status.getMsgByCode(status);
    }

    @Schema(description = "结算方式  1装车净重 2卸车净重")
    private Integer settlementWay;
    private String settlementWayMsg;
    public String getSettlementWayMsg() {
        return SettlementWayEnum.WayType.getMsgByCode(settlementWay);
    }


    @Schema(description="开票公司id",example = "1")
    private Integer invoicingCompanyId;  //开票公司id
    @Schema(description="开票公司简称",example = "1")
    private String invoicingCompanyShorterName; //开票公司简称
    @Schema(description="开票公司统一社会信用代码",example = "1")
    private String invoicingCompanyGroupCode;  //开票公司统一社会信用代码
    @Schema(description="是否上报 0-否;1-是",example = "1")
    private Integer reportFlag;  //是否上报 0-否;1-是

    @Schema(description="装货净重（单位吨）",example = "1.23")
    private BigDecimal loadNet;
    @Schema(description="卸货净重（单位吨）",example = "1.23")
    private BigDecimal unloadNet;

}
