package com.clx.performance.vo.pc.loan.carrier;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 借款配置
* @Date: 2024/01/17 13:42:57
* @Version: 1.0
*/

@Schema(description = "借款配置")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class BorrowerConfigVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "借出方id", example = "")
    private Integer borrowerId;
    @Schema(description = "借出方", example = "")
    private String borrowerName;
    @Schema(description = "类型：1虚拟货币 2 资金", example = "")
    private Integer type;
    @Schema(description = "借款天数", example = "")
    private Integer day;
    @Schema(description = "状态：1启用 2禁用", example = "")
    private Integer status;
    @Schema(description = "操作人编码", example = "1000")
    private Long opUserNo;
    @Schema(description = "操作人", example = "张三")
    private String opUserName;
    @Schema(description = "操作时间", example = "")
    private String opTime;
    @Schema(description = "创建人编号", example = "1000000")
    private Long createBy;
    @Schema(description = "创建人名称", example = "张三")
    private String createName;
    @Schema(description = "创建时间", example = "")
    private String createTime;

}