package com.clx.performance.vo.pc.linewarn;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.clx.performance.enums.linewarn.LineWarnConfigEnum;
import com.clx.performance.enums.linewarn.LineWarnInfoEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;
import java.util.Objects;

/**
* @Author: aiqinguo
* @Description: 车辆预警信息表
* @Date: 2024/04/25 17:09:33
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
public class LineWarnInfoVO {

    @Schema(description = "id", example = "1")
    private Integer id;
    @Schema(description = "预警id", example = "1")
    private Integer warnId;
    @Schema(description = "预警名称", example = "超时")
    private String warnName;
    @Schema(description = "预警类型: 1接单预警 2装车预警 3卸车预警 4拥堵预警 5天气预警 6运单异常 7线路异常", example = "1")
    private Integer warnType;
    @Schema(description = "预警类型", example = "1")
    private String warnTypeMsg;
    public String getWarnTypeMsg() {
        return LineWarnConfigEnum.WarnType.getMsgByCode(warnType);
    }
    @Schema(description = "预警级别", example = "1")
    private Integer warnLevel;
    @Schema(description = "预警级别", example = "一级")
    private String warnLevelMsg;
    public String getWarnLevelMsg() {
        if (warnLevel == 1) {return "一级";}
        if (warnLevel == 2) {return "二级";}
        if (warnLevel == 3) {return "三级";}
        return null;
    }

    @Schema(description = "货单编号", example = "100000")
    private String orderGoodsNo;
    @Schema(description = "发货地址id", example = "1")
    private Integer sendAddressId;
    @Schema(description = "发货地址", example = "北京")
    private String sendAddress;
    @Schema(description = "收货地址id", example = "2")
    private Integer receiveAddressId;
    @Schema(description = "收货地址", example = "山西")
    private String receiveAddress;
    @Schema(description = "运单状态", example = "1")
    private Integer childStatus;

    @Schema(description = "预警时间", example = "")
    private String warnTime;
    @Schema(description = "暂停时间", example = "")
    private String suspendTime;
    @Schema(description = "天气", example = "暴雨")
    private String weather;

    @Schema(description = "挂单数", example = "1")
    private Integer pengNum;
    @Schema(description = "接单数", example = "1")
    private Integer takeNum;
    @Schema(description = "到达货源地车数", example = "1")
    private Integer arriveSendNum;
    @Schema(description = "装车车数", example = "1")
    private Integer loadNum;
    @Schema(description = "到达目的地车数", example = "1")
    private Integer arriveReceiveNum;
    @Schema(description = "卸车车数", example = "1")
    private Integer unloadNum;

    @Schema(description = "处理状态：1待处理 2已处理 3暂停预警", example = "1")
    private Integer status;
    public Integer getStatus() {
        if (Objects.equals(status, LineWarnInfoEnum.Status.RESOLVE.getCode())) {return LineWarnInfoEnum.Status.RESOLVE.getCode();}

        if (StringUtils.isNotBlank(suspendTime)){
            if (LocalDateTimeUtil.parse(suspendTime,"yyyy-MM-dd HH:mm:ss").isBefore(LocalDateTime.now())) {
                return LineWarnInfoEnum.Status.INIT.getCode();
            } else {
                return LineWarnInfoEnum.Status.SUSPEND.getCode();
            }
        }
        return LineWarnInfoEnum.Status.INIT.getCode();
    }
    @Schema(description = "处理状态：1待处理 2已处理 3暂停预警", example = "待处理")
    private String statusMsg;
    public String getStatusMsg() {
        return LineWarnInfoEnum.Status.getMsgByCode(getStatus());
    }
    @Schema(description = "创建人", example = "")
    private String createBy;
    @Schema(description = "创建时间", example = "")
    private String createTime;
    @Schema(description = "修改时间", example = "")
    private String modifiedTime;

}