package com.clx.performance.vo.pc.integral;

import com.clx.performance.enums.integral.IntegralTruckRuleEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 车辆积分规则
* @Date: 2023/11/06 14:12:53
* @Version: 1.0
*/

@Schema(description = "车辆积分规则")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class AppIntegralTruckRuleVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "层级名称", example = "")
    private String name;
    @Schema(description = "积分起始范围", example = "")
    private Integer integralRatioBegin;
    @Schema(description = "积分结束范围", example = "")
    private Integer integralRatioEnd;

    @Schema(description = "积分结束范围", example = "")
    private String integralRatioMsg;
    public String getIntegralRatioMsg() {
        if (integralRatioBegin == null && integralRatioEnd !=null) {return "积分小于"+integralRatioEnd+"%";}
        if (integralRatioEnd == null && integralRatioBegin !=null) {return "积分大于"+integralRatioBegin+"%";}
        return "积分"+ integralRatioBegin+"%" + "—" + integralRatioEnd+"%";
    }

    @Schema(description = "状态：1开启 2关闭", example = "")
    private Integer status;

    @Schema(description = "状态：1开启 2关闭", example = "")
    private String statusMsg;
    public String getStatusMsg() {
        return IntegralTruckRuleEnum.Status.getByCode(status).get().getMsg();
    }

    @Schema(description = "预期收益开始范围（分）", example = "")
    private BigDecimal incomeBegin;
    @Schema(description = "预期收益结束范围（分）", example = "")
    private BigDecimal incomeEnd;

    @Schema(description = "预期收益结束范围", example = "")
    private String incomeMsg;
    public String getIncomeMsg() {
        if(incomeEnd == null && incomeBegin == null){ return StringUtils.EMPTY;}
        if (incomeBegin == null ) {return "日收益小于等于"+incomeEnd+"元";}
        if (incomeEnd == null) {return "日收益大于等于"+incomeBegin+"元";}
        return "日收益"+ incomeBegin + "元—" + incomeEnd+"元";
    }

    @Schema(description = "创建时间", example = "")
    private String createTime;
    @Schema(description = "修改时间", example = "")
    private String modifiedTime;

}