package com.clx.performance.vo.pc.collect;

import com.clx.performance.enums.collect.CollectTruckLocationEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 车辆位置上报
* @Date: 2023/10/16 13:06:26
* @Version: 1.0
*/

@Schema(description = "车辆位置上报")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CollectTruckLocationVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "用户编号", example = "")
    private Long userNo;
    @Schema(description = "用户姓名", example = "")
    private String name;
    @Schema(description = "手机号码", example = "")
    private String mobile;
    @Schema(description = "车牌号", example = "")
    private String truckNo;
//    @Schema(description = "省", example = "")
//    private String province;
//    @Schema(description = "市", example = "")
//    private String city;
//    @Schema(description = "区县", example = "")
//    private String county;
//    @Schema(description = "乡镇", example = "")
//    private String town;
//    @Schema(description = "街道", example = "")
//    private String street;
//    @Schema(description = "详细地址", example = "")
//    private String address;
    @Schema(description = "全地址", example = "")
    private String fullAddress;

    @Schema(description = "经度", example = "")
    private BigDecimal longitude;
    @Schema(description = "纬度", example = "")
    private BigDecimal latitude;
    @Schema(description = "车辆出车状态 1:空车 2重车", example = "", hidden = true)
    private Integer truckOrderStatus;
    @Schema(description = "车辆出车状态 1:空车 2重车", example = "")
    private String truckOrderStatusMsg;
    public String getTruckOrderStatusMsg() {
        return CollectTruckLocationEnum.TruckOrderStatus.getByCode(truckOrderStatus).get().getMsg();
    }

    @Schema(description = "上报时间", example = "")
    private String reportTime;
    @Schema(description = "创建时间", example = "")
    private String createTime;
    @Schema(description = "修改时间", example = "")
    private String modifiedTime;

}