package com.clx.performance.vo.pc.collect;


import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.time.LocalDateTime;

@Schema(description = "收集司机拉运意向选项")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CarrierDriverCollectTransportIntentionRecordVO {
    private Integer id;

    @Schema(description="收集司机拉运意向id")
    private Integer collectDriverTransportIntentionId;

    @Schema(description="选项排序编号")
    private Integer collectRecordSort;

    @Schema(description="选项名称")
    private String collectRecordName;

    @Schema(description="操作人编码")
    private Long createUserNo;

    @Schema(description="操作人")
    private String createUserName;

    @Schema(description="删除状态: 0-否;1-是")
    private Integer deleteStatus;

    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;
}
