package com.clx.performance.vo.pc.carrier.settle;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.List;


@Getter
@Setter
@ToString
@NoArgsConstructor
public class CarrierSettlementOwnerDetailVO {

    @Schema(description = "id", example = "1.23")
    private Integer id;

    @Schema(description = "货主用户编号", example = "123")
    private Long ownerUserNo;

    @Schema(description = "货主名称", example = "货主")
    private String ownerName;

    @Schema(description="结算方式  1装车净重 2卸车净重")
    private Integer settlementWay;

    @Schema(description = "结算单编号", example = "JS415")
    private String settlementNo;

    @Schema(description = "结算子单号", example = "JS012")
    private String settlementSubNo;

    @Schema(description = "结算周期类型：1拉运完成结 2月结", example = "")
    private Integer settlementPeriodType;
    @Schema(description = "结算周期时间（月结）", example = "")
    private String settlementPeriodTime;

    @Schema(description = "订单编号", example = "123")
    private String orderNo;

    @Schema(description = "实际净重（吨）", example = "1.23")
    private BigDecimal weight;
    @Schema(description = "装货净重（单位吨）", example = "1.23")
    private BigDecimal loadNet;
    @Schema(description = "卸货净重（单位吨）", example = "1.23")
    private BigDecimal unloadNet;

    @Schema(description = "实际运费（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freight;

    @Schema(description = "货损吨数（吨）", example = "1.23")
    private BigDecimal lossWeight;

    @Schema(description = "货损金额（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal lossFreight;

    @Schema(description = "预付运费金额（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal prepayFreight;

    @Schema(description = "结算金额（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal settlementFreight;

    @Schema(description = "借款金额（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal loanFreight;

    @Schema(description = "开票标识：1网运单 2普通单", example = "1")
    private Integer invoiceTypeCode;

    @Schema(description = "开票标识：1网运单 2普通单", example = "网运单")
    private String invoiceTypeMsg;

    @Schema(description = "开票金额（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal invoiceFreight;

    @Schema(description = "结算凭证", example = "/a.png")
    private String invoiceImg;

    @Schema(description = "开票服务费", example = "1.23")
    @MoneyOutConvert
    private BigDecimal invoiceServiceFee;

    @Schema(description = "收款人", example = "收款人")
    private String payee;

    @Schema(description = "收款银行", example = "浙江银行")
    private String payeeBankName;

    @Schema(description = "收款银行卡卡号", example = "62213545878787")
    private String payeeBankCardNo;

    @Schema(description = "付款凭证", example = "/a.png")
    private String paymentImg;

    @Schema(description = "付款银行", example = "浙江银行")
    private String paymentBankName;

    @Schema(description = "付款银行卡卡号", example = "62213545878787")
    private String paymentBankCardNo;

    @Schema(description = "公司名称", example = "公司名称")
    private String companyName;

    @Schema(description = "企业税号", example = "企业税号")
    private String companyTaxCode;

    @Schema(description = "公司地址", example = "公司地址")
    private String companyAddress;

    @Schema(description = "公司电话", example = "1222222222")
    private String companyMobile;

    @Schema(description = "公司开户行", example = "中国银行")
    private String companyBankName;

    @Schema(description = "公司银行账号", example = "6215454545")
    private String companyBankNo;

    @Schema(description = "公司联系人", example = "1.23")
    private String companyContact;

    @Schema(description = "公司联系电话", example = "公司联系人")
    private String companyContactMobile;

    @Schema(description = "公司联系地址", example = "公司联系地址")
    private String companyContactAddress;

    @Schema(description = "快递公司", example = "顺风")
    private String expressCompany;

    @Schema(description = "快递编号", example = "SF145787")
    private String expressNo;

    @Schema(description = "开票状态code 1-已开票 2-部分开票 3-无需开票", example = "1")
    private Integer invoiceStatusCode;

    @Schema(description = "开票状态Msg 1-已开票 2-部分开票 3-无需开票", example = "无需开票")
    private String invoiceStatusMsg;

    @Schema(description = "状态code 10:待锁定  20:待对账  30:待货主确认 40:待货主付款 50:待平台确认付款 60:待平台付款 70:待货主确认付款 80:待邮寄发票 90:已完结", example = "10")
    private Integer statusCode;

    @Schema(description = "状态Msg", example = "待锁定")
    private String statusMsg;

    @Schema(description = "驳回原因", example = "驳回原因")
    private String remark;

    @Schema(description = "创建时间", example = "2023-01-01 00:00:00")
    private String createTime;

    @Schema(description = "结算单合并明细")
    private List<SettlementMergeVO> mergers;

    @Schema(description = "结算单操作日志")
    private List<SettlementLogVO> settlementLogs;

    @Schema(description="开票公司简称")
    private String invoicingCompanyShorterName;
    @Schema(description="开票公司统一社会信用代码")
    private String invoicingCompanyGroupCode;
    @Schema(description="是否上报 0-否;1-是")
    private Integer reportFlag;


}