package com.clx.performance.vo.pc.broker;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OpenOrderChildDriverDTO {

    @Schema(description = "手机号")
    private String mobile;
    @Schema(description = "姓名")
    private String name;
    @Schema(description = "性别1男2女")
    private Integer sex;
    @Schema(description = "头像相对地址")
    private String headImg;
    @Schema(description = "身份证号")
    private String cardNo;
    @Schema(description = "身份证住址")
    private String idCardAddress;
    @Schema(description = "身份证有效期起始时间")
    private String cardStartTime;
    @Schema(description = "身份证有效期终止时间")
    private String cardEndTime;
    @Schema(description = "是否是长期 0-非长期 1-长期")
    private Integer cardLongTerm;
    @Schema(description = "身份证正面图片地址")
    private String cardFrontImg;
    @Schema(description = "身份证背面图片地址")
    private String cardBackImg;
    @Schema(description = "手持身份证照片地址")
    private String faceCardImg;
    @Schema(description = "驾驶证号码")
    private String licenceNo;
    @Schema(description = "驾驶证发证机关")
    private String licenceIssueOrganization;
    @Schema(description = "初次领证日期")
    private String licenseTime;
    @Schema(description = "驾照类型")
    private String licenceClass;
    @Schema(description = "驾驶证正面图片")
    private String licenceImg;
    @Schema(description = "驾驶证背面图片")
    private String licenceBackImg;
    @Schema(description = "驾驶证有效期起始时间")
    private String licenceStartTime;
    @Schema(description = "驾驶证有效期终止时间")
    private String licenceEndTime;
    @Schema(description = "道路运输许可证图片地址")
    private String transportLicenceImg;
    @Schema(description = "道路运输从业资格证号")
    private String occupationalLicenceNo;
    @Schema(description = "道路运输从业资格证图片地址")
    private String occupationalLicenceImg;
    @Schema(description = "从业资格证有效期起始时间")
    private String occupationalStartTime;
    @Schema(description = "从业资格证有效期终止时间")
    private String occupationalEndTime;

    @Schema(description = "银行卡卡号", example = "", required = true)
    private String bankCardNo;
    @Schema(description = "银行预留手机号", example = "", required = true)
    private String bankMobile;
    @Schema(description = "银行名称", example = "", required = true)
    private String bankName;

}
