package com.clx.performance.vo.pc.breakcontract.carrier;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


@Getter
@Setter
@ToString
@NoArgsConstructor
public class PageCarrierBreakContractSettlementOwnerVO {

    @Schema(description="id")
    private Integer id;

    @Schema(description="违约方类型：1平台 2货主 3车主")
    private Integer breakContractPartyType;

    @Schema(description="违约方类型Msg：1平台 2货主 3车主")
    private String breakContractPartyTypeMsg;

    @Schema(description="结算单号")
    private String settlementNo;

    @Schema(description="货主用户编号")
    private Long ownerUserNo;

    @Schema(description="货主名称")
    private String ownerName;

    @Schema(description="订单编号")
    private String orderNo;

    @Schema(description="状态msg")
    private String statusMsg;

    @Schema(description="状态")
    private Integer status;

    @MoneyOutConvert
    @Schema(description="违约金")
    private BigDecimal figure;

    @Schema(description="操作人名称")
    private String createName;

    @Schema(description="创建时间")
    private String createTime;


}