package com.clx.performance.vo.pc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 运单表
* @Date: 2023/09/18 11:34:50
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
public class PageOrderChildPoundAuditVO {

    @Schema(description="运单编号",example = "41441")
    private String childNo;

    @Schema(description="货物名称",example = "煤炭")
    private String goodsName;

    @Schema(description="发货地址",example = "吉林")
    private String sendAddress;

    @Schema(description="收货地址",example = "山西")
    private String receiveAddress;

    @Schema(description="司机姓名",example = "张安")
    private String driverName;

    @Schema(description="司机手机号",example = "12222222222")
    private String driverMobile;

    @Schema(description="装货净重",example = "10")
    private BigDecimal loadNet;

    @Schema(description="卸货净重",example = "41")
    private BigDecimal unloadNet;

    @Schema(description = "装货毛重", example = "10")
    private BigDecimal loadRough;

    @Schema(description = "装货皮重", example = "10")
    private BigDecimal loadTare;

    @Schema(description="卸货毛重",example = "41")
    private BigDecimal unloadRough;

    @Schema(description="卸货皮重",example = "41")
    private BigDecimal unloadTare;

    @Schema(description="审核状态 0 待审核 1 审核通过 2 审核驳回",example = "1")
    private Integer status;

    @Schema(description="接单时间",example = "2020-01-01 10:10:10")
    private String payTime;

    @Schema(description="装车时间",example = "2020-01-01 10:10:10")
    private String loadTime;

    @Schema(description="卸车时间",example = "2020-01-01 10:10:10")
    private String unloadTime;

    @Schema(description="车牌号")
    private String truckNo;



}