package com.clx.performance.vo.pc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class OwnerLoanAccountVO {

    private Integer id;

    @Schema(description="货主编码")
    private Long ownerUserNo;

    @Schema(description="货主名称")
    private String ownerUserName;

    @Schema(description="联系电话")
    private String mobile;

    @Schema(description="账户类型： 默认3 借款账户")
    private Integer accountType;

    @Schema(description="资金金额")
    private BigDecimal fundingAmount;

    @Schema(description="虚拟币金额")
    private BigDecimal virtuallyAmount;

    @Schema(description="资金欠款")
    private BigDecimal fundingArrears;

    @Schema(description="虚拟币欠款")
    private BigDecimal virtuallyArrears;

    @Schema(description="创建人")
    private String createBy;

    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;
}
