package com.clx.performance.vo.pc;

import com.clx.performance.vo.feign.OwnerInfoVO;
import com.msl.common.convertor.field.Converted;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
public class OwnerAccountAllVO {

    @Schema(description="保证金账户")
    @Converted(isDynamic = true)
    private OwnerAccountVO marginAccount;

    @Schema(description="预付运费账户")
    @Converted(isDynamic = true)
    private OwnerAccountVO prepaidFreightAccount;

    @Schema(description="0:没有交易密码  1：有交易密码")
    private Integer ownerAccountPassword;

    @Schema(description="借款账户信息")
    private OwnerLoanAccountVO loanAccountVO;

    @Schema(description="货主信息")
    private OwnerInfoVO ownerInfoVO;
}
