package com.clx.performance.vo.pc;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
@Getter
@Setter
@Accessors(chain = true)
public class NetworkDriverAccountVO {

    private Integer id;

    @Schema(description="司机编码")
    private String driverUserNo;

    @Schema(description="司机名称")
    private String driverUserName;

    @Schema(description="联系电话")
    private String mobile;

    @Schema(description="账户余额")
    @MoneyOutConvert
    private BigDecimal accountBalance;

    @Schema(description="可用余额")
    @MoneyOutConvert
    private BigDecimal usableBalance;

    @Schema(description="冻结余额")
    @MoneyOutConvert
    private BigDecimal frozenBalance;

    @Schema(description="钱包code")
    private String walletCode;

    @Schema(description="创建人")
    private String createBy;

    @Schema(description="创建时间")
    private String createTime;

    @Schema(description="修改时间")
    private String modifiedTime;

}
