package com.clx.performance.vo.pc;

import com.msl.common.convertor.field.Converted;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName GoodsOrderSendAddressSelect
 * @Description
 * @Author kavin
 * @Date 2023/10/10 10:44
 * @Version 1.0
 */

@Schema(description = "货单地图货源地下拉选")
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class GoodsOrderSendAddressSelect {

    @Schema(description="订单编号")
    private String orderNo;

    @Schema(description="发货地址ID")
    private Integer sendAddressId;

    @Schema(description="发货地址简称")
    private String sendAddressShorter;

    @Schema(description="发货地址经度")
    private BigDecimal sendLongitude;

    @Schema(description="发货地址纬度")
    private BigDecimal sendLatitude;

    @Converted(isDynamic = true)
    @Schema(description="挂单运费")
    private List<Freight> freightList;


}
