package com.clx.performance.vo.pc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


/**
 * 司机通知配置
 * @author jiangwujie
 */
@Getter
@Setter
@ToString
public class DriverNoticeConfigVO {

    @Schema(description = "id")
    private Integer id;

    @Schema(description="配置名称")
    private String name;
    
    @Schema(description = "通知触发距离：默认1.5，最大9999.9")
    private BigDecimal noticeTriggerDistance;

    @Schema(description = "启用状态：0禁用 1启用")
    private Integer status;

    public Integer getNoticeTriggerDistanceMeter() {
        return noticeTriggerDistance != null ? noticeTriggerDistance.multiply(new BigDecimal(1000)).intValue() : 0;
    }
}
