package com.clx.performance.vo.app;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.time.LocalDateTime;


@Schema(description = "运单表")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class GoingOrderChildVO {

    @Schema(description = "运单编号", example = "100000000")
    private String childNo;

    @Schema(description = "发货地址", example = "朝阳")
    private String sendAddress;

    @Schema(description = "收货地址", example = "西城")
    private String receiveAddress;

    @Schema(description = "最晚装货时间", example = "2012-01-01 00:00:00")
    private String loadDeadline;

    @Schema(description = "车牌号", example = "京A12345")
    private String truckNo;

    @Schema(description = "状态", example = "0")
    private Integer status;

    @Schema(description = "最晚到达货源地时间", example = "2012-01-01 00:00:00")
    private String lastArriveSendTime;


    @Schema(description = "最晚到达目的地时间", example = "2012-01-01 00:00:00")
    private String lastArriveReceiveTime;


    @Schema(description = "最晚装货时间", example = "2012-01-01 00:00:00")
    private String lastLoadTime;


}