package com.clx.performance.param.pc.owner;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
@ToString
public class PageInvoiceOwnerSettlementOwnerDetailParam extends PageParam {

    @NotNull(message = "是否已开票不能为空")
    @Schema(description = "是否已开票，0：否，1：是")
    private Integer invoiceStatus;

    @Schema(description = "货主用户编号")
    private Long ownerUserNo;

    @Schema(description = "货主名称")
    private String ownerName;

    @Schema(description = "结算单编号")
    private String settlementNo;

    @Schema(description="运单编号")
    private String childNo;

    @Schema(description="开票公司")
    private String invoicingCompanyShorterName;

    @Schema(description="开票标识：1网运单 2普通单")
    private Integer invoiceType;

    @Schema(description = "开始时间")
    private String beginTime;

    @Schema(description = "结束时间")
    private String endTime;
}
