package com.clx.performance.param.pc.loan.owner;

import com.msl.common.convertor.type.MoneyInConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;

@Setter
@Getter
@ToString
@NoArgsConstructor
public class OwnerLoanRecordParam {

    @Schema(description = "借款金额", example = "张三")
    @NotNull(message = "借款金额不能为空")
    @MoneyInConvert
    private BigDecimal loanBalance;

    @Schema(description = "借出方ID", example = "伟华煤炭运销公司")
    @NotNull(message = "借出方ID不能为空")
    private Integer borrowerId;


    @Schema(description = "借出方", example = "诚联信网络科技有限公司")
    @NotBlank(message = "借出方不能为空")
    private String borrower;

    @Schema(description = "收款方")
    private String payee;

    @Schema(description = "收款方账户")
    private String payeeAccount;


    @Schema(description = "借款方", example = "伟华煤炭运销公司")
    @NotBlank(message = "借款方不能为空")
    private String lendingParty;

    @Schema(description = "借款方账户", example = "诚联信银行账户")
    @NotBlank(message = "借款方不能为空")
    private String lendingPartyAccount;

    @Schema(description = "借出时效（天）", example = "2")
    @NotNull(message = "借出时效（天）不能为空")
    private Integer expireDay;
}
