package com.clx.performance.param.pc.integral;

import com.clx.performance.vo.pc.integral.AppIntegralRuleVO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.Valid;

/**
 * @Author: aiqingguo
 * @Description: 新增积分
 * @Date: 2023-10-11 17:30:57
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class IntegralRuleUpdateParam {

    @Valid
    @Schema(description = "运单完成积分规则")
    private AppIntegralRuleVO.OrderChildCompleteRule orderChildCompleteRule;

    @Valid
    @Schema(description = "货单奖励积分规则")
    private AppIntegralRuleVO.OrderAwardRule orderAwardRule;

    @Valid
    @Schema(description = "货单扣减积分规则")
    private AppIntegralRuleVO.OrderChildCancelRule orderDiscountRule;

    @Valid
    @Schema(description = "运单超时扣减规则")
    private AppIntegralRuleVO.OrderChildTimeoutRule orderChildTimeoutRule;

    @Valid
    @Schema(description = "平台补偿积分规则")
    private AppIntegralRuleVO.PlatformCompensationRule platformCompensationRule;

    @Valid
    @Schema(description = "司机上报积分规则")
    private AppIntegralRuleVO.DriverReportRule driverReportRule;

}
