package com.clx.performance.param.pc.breakcontract.carrier;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;

@Setter
@Getter
@ToString
@NoArgsConstructor
public class CarrierUploadInvoiceImgParam  {

    @NotNull(message = "id不能为空")
    @Schema(description = "id", example = "100")
    private Integer id;

    @NotBlank(message = "结算凭证不能为空")
    @Size(max=255,message = "结算凭证最多输入255个字符")
    @Schema(description="结算凭证",example = "/123.img")
    private String invoiceImg;

}
