package com.clx.performance.param.pc.breakcontract.carrier;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;

@Setter
@Getter
@ToString
@NoArgsConstructor
public class CarrierBreakContractSavePayeeParam {

    @NotNull(message = "id不能为空")
    @Schema(description = "id", example = "100")
    private Integer id;

    @NotBlank(message = "收款人不能为空")
    @Size(max=64,message = "收款人最多输入64个字符")
    @Schema(description = "收款人", example = "收款人")
    private String payee;

    @NotBlank(message = "收款银行不能为空")
    @Size(max=64,message = "收款银行最多输入64个字符")
    @Schema(description = "收款银行", example = "浙江银行")
    private String payeeBankName;

    @NotBlank(message = "收款银行卡卡号不能为空")
    @Size(max=32,message = "收款银行卡卡号最多输入32个字符")
    @Schema(description = "收款银行卡卡号", example = "62213545878787")
    private String payeeBankCardNo;

    @NotBlank(message = "付款凭证不能为空")
    @Size(max=255,message = "付款凭证最多输入255个字符")
    @Schema(description = "付款凭证", example = "/a.png")
    private String paymentImg;

    @NotBlank(message = "付款银行不能为空")
    @Size(max=64,message = "付款银行最多输入64个字符")
    @Schema(description = "付款银行", example = "浙江银行")
    private String paymentBankName;

    @NotBlank(message = "付款银行卡卡号不能为空")
    @Size(max=32,message = "付款银行卡卡号最多输入32个字符")
    @Schema(description = "付款银行卡卡号", example = "62213545878787")
    private String paymentBankCardNo;

    @Schema(description = "状态", example = "1",hidden = true)
    private Integer status;

    @Schema(description = "交易密码")
    private String accountPassword;

}
