package com.clx.performance.param.pc;

import com.clx.performance.param.app.PositionParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
public class SettlementInvoiceExpressParam extends PositionParam {

    @Schema(description = "结算id", example = "1")
    @NotNull(message = "结算id不能为空")
    private Integer settlementId;

    @Schema(description = "快递公司", example = "顺丰")
    @NotBlank(message = "快递公司不能为空")
    private String expressCompany;

    @Schema(description = "快递编号", example = "1000000")
    @NotBlank(message = "快递编号不能为空")
    private String expressNo;

}
