package com.clx.performance.param.pc;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import java.util.List;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class QueryOrderChildsListByParam extends PageParam {

    @Schema(description = "运单状态集合")
    private List<Integer> statusList;

    @Schema(description = "货单编号")
    @NotBlank(message = "货单编号不能为空")
    private String orderGoodsNo;

}
