package com.clx.performance.param.pc;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotNull;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class PageOrderGoodsListParam extends PageParam {

    @Schema(description = "订单来源: 1数煤宝 2承运货主 3供应链")
    private Integer orderSource;

    @Schema(description = "订单编号")
    private String orderNo;

    @Schema(description = "货单编号")
    private String orderGoodsNo;

    @Schema(description = "货单状态： 10：已挂单  20：挂单中 30：运输中 40：已完成 50：已取消 60:已完结")
    private Integer orderGoodsStatus;

    @Schema(description = "开始时间", example = "2023-09-09 12:00:01")
    private String beginTime;

    @Schema(description = "结束时间", example = "2023-09-09 12:00:01")
    private String endTime;

    @Schema(description = "用车类型： 1平台车辆 2部分平台车辆 3自有车辆")
    private Integer truckDemand;

    @Schema(description="发货地址",example = "北京")
    private String sendAddress;

    @Schema(description="收货地址",example = "黄羊城")
    private String receiveAddress;

    @Schema(description="用车方式 1：平台车辆配货 2：自有车辆配货")
    private Integer vehicleUsage;

}
