package com.clx.performance.param.pc;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotBlank;
import java.util.List;

/**
 * @Author liruixin
 * @create 2023-09-19 13:33
 */
@Getter
@Setter
@NoArgsConstructor
@ToString
public class PageCarrierOrderChildParam extends PageParam {

    @Schema(description = "订单来源: 1数煤宝 2承运货主 3供应链")
    private Integer orderSource;

    @Schema(description = "订单编号")
    private String orderNo;

    @Schema(description = "货单编号")
    private String orderGoodsNo;

    @Schema(description="运单编号",example = "201457878")
    private String childNo;

    @Schema(description="司机姓名",example = "募资类")
    private String driverName;

    @Schema(description="司机手机号",example = "12222222222")
    private String driverMobile;

    @Schema(description="发货地址",example = "北京")
    private String sendAddress;

    @Schema(description="收货地址",example = "黄羊城")
    private String receiveAddress;

    @Schema(description="状态",example = "1")
    private Integer status;

    @Schema(description="开始时间",example = "2020-01-01 10:10:10")
    private String beginTime;

    @Schema(description = "结束时间",example = "2020-01-01 10:10:10")
    private String endTime;

    @Schema(description = "车牌号",example = "晋A12345")
    private String truckNo;

    @Schema(description = "运单状态集合")
    private List<Integer> statusList;

    @Schema(description = "时间筛选类型，1：接单时间，2：磅单审核通过时间，3：完成时间")
    private Integer timeType;

}
