package com.clx.performance.param.pc;

import com.msl.common.convertor.type.MoneyInConvert;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


@Schema(description = "货主充值")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class OwnerTopUpParam {

    @Schema(description = "货主用户编号", example = "123")
    private Long ownerUserNo;

    @Schema(description = "充值金额（元）", example = "1.23")
    @MoneyInConvert
    private BigDecimal topUpBalance;

    @Schema(description = "账户类型： 1：保证金 2：预付运费", example = "1")
    private Integer accountType;

    @Schema(description = "打款银行", example = "浙江银行")
    private String drawingBank;

    @Schema(description = "打款银行卡号", example = "62213545878787")
    private String drawingBankNumber;

    @Schema(description = "打款凭证", example = "/a.png")
    private String drawingProof;

    @Schema(description = "收款人企业信息", example = "收款人企业信息")
    private String enterpriseName;

    @Schema(description = "收款人开户行", example = "62213545878787")
    private String openAccountBank;

    @Schema(description = "收款人开户行银行代码", example = "收款人开户行银行代码")
    private String openAccountBankNumber;

    @Schema(description = "收款人账户账号", example = "")
    private String accountNumber;

    @Schema(description = "交易密码")
    private String accountPassword;

}