package com.clx.performance.param.pc;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

/**
 * @Author: aiqingguo
 * @Description: 新增积分
 * @Date: 2023-10-11 17:30:57
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class IntegralRecordAddParam {

    @Schema(description = "车牌", example = "京A12345")
    @NotBlank(message = "车牌号不能为空")
    private String truckNo;
    @Schema(description = "积分", example = "1")
    @NotNull(message = "积分不能为空")
    private Integer integral;
    @Schema(description = "原因", example = "平台补偿")
    @NotBlank(message = "原因不能为空")
    private String remark;

}
