package com.clx.performance.param.app.collect;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class CollectTruckRefuelSaveParam {

    @Schema(description = "运单编号", example = "10000000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @Schema(description = "装车油表图片列表")
    @NotEmpty(message = "装车油表图片不能为空")
    private List<String> loadImageList;
    @Schema(description = "卸车油表图片列表")
    @NotEmpty(message = "卸车油表图片不能为空")
    private List<String> unloadImageList;

    @Schema(description = "装车油量", example = "1.23")
    private BigDecimal loadOil;
    @Schema(description = "卸车油量", example = "1.23")
    private BigDecimal unloadOil;

}
