package com.clx.performance.param.app.collect;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class CollectTrafficCongestionSaveParam {

    @Schema(description = "经度")
    private BigDecimal longitude;
    @Schema(description = "纬度")
    private BigDecimal latitude;

    @Schema(description = "省", example = "")
    private String province;
    @Schema(description = "市", example = "")
    private String city;
    @Schema(description = "区县", example = "")
    private String county;
    @Schema(description = "乡镇", example = "")
    private String town;
    @Schema(description = "街道", example = "")
    private String street;
    @Schema(description = "详细地址", example = "北京路1号")
    private String address;

    @Schema(description = "预计拥堵时长（小时）", example = "1.5")
    private BigDecimal jamTime;
    @Schema(description = "现场照片列表")
    private List<String> jamImageList;


}
