package com.clx.performance.param.app;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class OrderChildDriverCancelParam extends PositionParam {

    @Schema(description = "运单编号", example = "100000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @Schema(description = "取消原因类型：1个人原因, 2价格不合适, 3无法装货, 4车辆原因, 5交通管制, 6交通事故, 7无法找到地址, 8排队时间较长, 9其他原因", example = "1")
    private Integer cancelType;

    @Schema(description = "取消原因", example = "信息错误")
    private String remark;

    @Schema(description = "图片列表")
    private List<String> imageList;

}
