package com.clx.performance.param.app;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

/**
 * @author yangqifa
 */
@Getter
@Setter
@NoArgsConstructor
public class OcrRecognitionParam {

    @Schema(description = "运单编号", example = "100000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @Schema(description = "图片类型,1:装车磅单,2:卸车磅单")
    @NotNull(message = "图片类型不能为空")
    private Integer imageType;

    @Schema(description = "磅单图片url")
    @NotBlank(message = "磅单图片url不能为空")
    private String imageUrl;

}
