package com.clx.performance.param.app;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;

@Getter
@Setter
@NoArgsConstructor
public class AppGoodsOrderSearchParam extends PageParam {

    @Schema(description = "1：货源地 2: 目的地", example = "1")
    @NotBlank(message = "查询类型")
    private Integer searchType;

    @Schema(description = "搜索条件", example = "1")
    private String searchName;
}
