package com.clx.performance.feign;

import com.clx.performance.param.pc.driver.NetworkDriverAccountParam;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.Operation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = "clx-performance",configuration = PerformanceClientConfiguration.class)
public interface NetworkFeign {

    @Operation(summary = "新增网络货运司机账户")
    @PostMapping("clx-performance/feign/driver/createNetworkDriverAccount")
    Result<Object> createNetworkDriverAccount(@RequestBody @Validated NetworkDriverAccountParam param);

}
