package com.clx.performance.feign;

import com.msl.common.result.Result;
import jakarta.validation.constraints.NotBlank;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name = "msl-document",configuration = PerformanceClientConfiguration.class)
public interface DocumentFeign {

    /**
     * 获取用户协议
     *
     * @param agreementNo
     * @return
     */
    @GetMapping(value = {"/msl-document/agreement/getCurrentUserVersion"})
    String getCurrentUserVersion(@RequestParam("agreementNo") @NotBlank(message = "编号不可为空") String agreementNo);

    /**
     * @Author kavin
     * @Description 获取oss的domain
     * @Param []
     * @return
     **/
    @GetMapping({"/msl-document/fileUpload/getHost"})
    Result<String> getHost();

}
