package com.clx.performance.enums.settle;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum SettlementDriverEnum {
    ;
    @Getter
    @AllArgsConstructor
    public enum InvoiceType {
        ONLINE(1, "网运单"),
        ORDINARY(2, "普通单");
        private final Integer code;
        private final String msg;

        public static Optional<InvoiceType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(InvoiceType::getMsg).orElse(null);
        }
    }



    @Getter
    @AllArgsConstructor
    public enum Status {
        DRIVER_UNCONFIRMED(0, "待司机确认交货"),
        WAIT_SETTLEMENT(1, "待结算"),
        SETTLED(2, "已结算"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Status::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum PrepayFreightFlag {
        PAYED(1, "已预付"),
        NO_PAY(0, "未预付");
        private final Integer code;
        private final String msg;

        public static Optional<PrepayFreightFlag> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(PrepayFreightFlag::getMsg).orElse(null);
        }
    }

}
