package com.clx.performance.enums.payment;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author huningning
 * Date 2024-06-18
 * Time 14:01
 */
public enum PayOperationStatusEnum {
    FREEZE(1, "冻结"),
    ADJUSTMENT(2, "调整"),
    UNFREEZE(3, "解冻"),
    PART_UNFREEZE(4, "部分解冻"),
    PART_PAY(5, "部分支付"),
    PAY(6, "支付"),
    COMPLETE(7, "完成")
    ;

    private static Map<Integer, String> map = new ConcurrentHashMap<>();
    static {
        for(PayOperationStatusEnum payOperationStatusEnum : PayOperationStatusEnum.values()){
            map.put(payOperationStatusEnum.getValue(), payOperationStatusEnum.getDisplayValue());
        }
    }
    private int value;
    private String displayValue;

    public void setValue(int value) {
        this.value = value;
    }

    public String getDisplayValue() {
        return displayValue;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    private PayOperationStatusEnum(int value, String displayValue){
        this.value = value;
        this.displayValue = displayValue;
    }
    public int getValue(){
        return value;
    }
    public static String toString(int value){
        return map.get(value);
    }
}
