package com.clx.performance.enums.nbbank;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum NbBankStatusEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {
        TEMP(0, "中间态"),
        SUCCESS(1, "交易成功"),
        FAIL(2, "交易失败"),

        ACCEPT(3, "交易已受理"),
        INIT(4, "订单初始状态"),
        NOT_FOUND(5, "交易不存在"),
        TIMEOUT(6, "交易超时,须发起交易结果查询"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Status::getMsg).orElse(null);
        }
    }

}
