package com.clx.performance.enums.nbbank;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum NbBankRecordEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {
        DIRECT_BANK_TRANSFER_ORDER(1, "转账直连下单"),
        UNION_PAY_DIRECT_ORDER(2, "银联订单支付收款模式"),
        QUERY_ORDER(3, "交易结果查询"),
        NOTIFY_MERCHANT(4, "异步通知交易结果"),
        FUND_TRANSFER_ORDER(5, "云账簿资金划转"),
        REFUND(6, "退款"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<Type> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Type::getMsg).orElse(null);
        }
    }

}
