package com.clx.performance.enums.loan;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum OwnerLoanRecordEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {
        APPROVE_WAIT(10, "待审批"),
        PAY_WAIT(15, "待付款"),
        APPROVE_PASS(20, "审批通过"),
        APPROVE_REFUSE(30, "审批拒绝"),
        PAYING(40, "付款中"),
        PAY_SUCCESS(50, "付款成功"),
        PAY_FAIL(60, "付款失败"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<Status> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.code, code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(Status::getMsg).orElse(null);
        }
    }

    //1:虚拟货币  2:资金
    @Getter
    @AllArgsConstructor
    public enum LoanType {
        VIRTUAL_CURRENCY(1, "虚拟货币"),
        FUND(2, "资金"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<LoanType> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e ->Objects.equals(e.code, code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(LoanType::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum LoanFlag {
        NO_LOAN(0, "未借款"),
        LOAN(1, "已借款"),
        RE_PAY(2, "已还款"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<LoanFlag> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e ->Objects.equals(e.code, code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(LoanFlag::getMsg).orElse("无需借款");
        }
    }

    @Getter
    @AllArgsConstructor
    public enum LoanTypeFlag {
        V_F(0, "虚拟币+资金"),
        VIRTUAL_CURRENCY(1, "虚拟币"),
        FUND(2, "资金"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<LoanTypeFlag> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e ->Objects.equals(e.code, code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(LoanTypeFlag::getMsg).orElse("");
        }
    }

    @Getter
    @AllArgsConstructor
    public enum PayChannel {
        ORDER_DIRECT_PAY(1, "订单支付"),
        ORDER_TRANSFER_PAY(2, "转账支付"),
        ASSET(3,"财资")
        ;

        private final Integer code;
        private final String msg;

        public static Optional<PayChannel> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e ->Objects.equals(e.code, code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(PayChannel::getMsg).orElse(null);
        }
    }

}
