package com.clx.performance.enums.linewarn;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum LineWarnRangEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {
        ENABLE(1, "有效"),
        DISABLE(2, "无效"),

        ;

        private final Integer code;
        private final String msg;
        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(Status::getMsg).orElse(null);
        }
    }


}
