package com.clx.performance.enums.linewarn;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum LineWarnConfigEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum WarnType {
        TAKE(1, "接单预警"),
        LOAD(2, "装车预警"),
        UNLOAD(3, "卸车预警"),

        CONGESTION(4, "拥堵预警"),
        WEATHER(5, "天气预警"),
        CHILD_ABNORMAL(6, "运单异常"),
        LINE_ABNORMAL(7, "线路异常"),

        ;

        private final Integer code;
        private final String msg;
        public static Optional<WarnType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(WarnType::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum DeleteStatus {
        NO(0, "否"),
        YES(1, "是"),

        ;

        private final Integer code;
        private final String msg;
        public static Optional<DeleteStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(DeleteStatus::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum Status {
        ENABLE(1, "启用"),
        DISABLE(2, "禁用"),

        ;

        private final Integer code;
        private final String msg;
        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(Status::getMsg).orElse(null);
        }
    }

}
