package com.clx.performance.enums.collect;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum CollectTruckLocationEnum {
    ;
    private Integer truckOrderStatus;               //车辆出车状态 1:空车 2:重车
    @Getter
    @AllArgsConstructor
    public enum TruckOrderStatus {
        EMPTY(1, "空车"),
        HEAVY(2, "重车"),

        ;

        private final int code;
        private final String msg;

        public static Optional<TruckOrderStatus> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

}
