package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OrderGoodsEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum SendWaitModeEnum {
        // 发货-排队系统形式  1:小程序  2:app
        WECHAT_PROGRAM(1, "微信小程序"),
        APP(2, "app");

        private final Integer code;
        private final String msg;


        public static Optional<SendWaitModeEnum> getByCode(Integer code) {
            if (code == null) {
                return Optional.empty();
            }
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(SendWaitModeEnum::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum SendWaitSystemMsgEnum {

        YES(1, "需要"),
        NO(0, "不需要");

        private final Integer code;
        private final String msg;


        public static Optional<SendWaitSystemMsgEnum> getByCode(Integer code) {
            if (code == null) {
                return Optional.empty();
            }
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public static String getMsgByCode(Integer code) {
            return getByCode(code).map(SendWaitSystemMsgEnum::getMsg).orElse(null);
        }
    }

    public static void main(String[] args) {
        System.out.println(SendWaitModeEnum.getMsgByCode(null));
    }
}
