package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@Getter
@AllArgsConstructor
public enum EnabledStatusEnum {
    ENABLE(1, "启用"),
    DISABLE(0, "禁用"),
    ;

    private final Integer code;
    private final String msg;

    public static Optional<EnabledStatusEnum> getByCode(Integer code) {
        return Arrays.stream(values()).filter(e -> Objects.equals(e.code, code)).findFirst();
    }

    public static String getMsgByCode(Integer code) {
        return getByCode(code).map(EnabledStatusEnum::getMsg).orElse(null);
    }
}