package com.clx.performance.struct.trace;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.esplus.model.DriverTraceESPlus;
import com.clx.performance.vo.pc.trace.DriverTraceVO;
import com.msl.common.utils.DateStructUtil;
import com.msl.common.utils.DateUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.math.BigDecimal;
import java.util.List;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {DateUtils.class, BigDecimal.class})
public interface DriverTraceStruct {

    @Mapping(target = "longitude", expression = "java(item.getLocation()[0])")
    @Mapping(target = "latitude", expression = "java(item.getLocation()[1])")
    @Mapping(target = "gpsTime", source = "positionTime")
    DriverTraceVO convert(DriverTraceESPlus item);
    List<DriverTraceVO> convert(List<DriverTraceESPlus> list);
    Page<DriverTraceVO> convertPage(IPage<DriverTraceESPlus> page);

}
