package com.clx.performance.struct.breakcontract;

import com.clx.performance.enums.BreakContractSettlementDriverEnum;
import com.clx.performance.model.breakcontract.BreakContractOwnerRecord;
import com.clx.performance.model.breakcontract.BreakContractSettlementOwnerDetail;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerDetailVO;
import com.msl.common.utils.DateStructUtil;
import com.msl.common.utils.DateUtils;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.util.List;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {BreakContractSettlementDriverEnum.class,  DateUtils.class})
public interface BreakContractSettlementOwnerDetailStruct {


    @Named("toBaseVo")
    @Mapping(target = "breakContractPartyTypeMsg", expression = "java(BreakContractSettlementDriverEnum.BreakContractPartyType.getMsgByCode(detail.getBreakContractPartyType()))")
    PageCarrierBreakContractSettlementOwnerDetailVO convert(BreakContractSettlementOwnerDetail detail);

    @IterableMapping(qualifiedByName = "toBaseVo")
    List<PageCarrierBreakContractSettlementOwnerDetailVO> covertToCarrierList(List<BreakContractSettlementOwnerDetail> list);

    @Mapping(target = "breakContractRemark", source = "remark")
    BreakContractSettlementOwnerDetail convert(BreakContractOwnerRecord detail);
}
