package com.clx.performance.sqlProvider.settle;

import com.clx.performance.enums.settle.SettlementDriverEnum;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.stream.Collectors;

public class SettlementDriverDetailSqlProvider {


    public String listUnPay() {
        return new SQL(){{
            SELECT("a.* ");
            FROM("settlement_owner_detail a ");
            LEFT_OUTER_JOIN("settlement_driver b on a.settlement_no = b.settlement_no ");
            WHERE("b.create_time >= #{beginTime}");
            WHERE("b.status = " + SettlementDriverEnum.Status.WAIT_SETTLEMENT.getCode());
            ORDER_BY("b.create_time");
        }}.toString();
    }


    public String findByDriverSettlementIds(List<Integer> ids) {
        return new SQL(){{
            SELECT("a.* ");
            FROM("settlement_driver_detail a ");
            LEFT_OUTER_JOIN("settlement_driver b on a.child_no = b.child_no ");
            WHERE("b.id IN ( "  + ids.stream().map(code -> "'"+code+"'").collect(Collectors.joining(","))+ ")" );
            WHERE("b.status = " + SettlementDriverEnum.Status.WAIT_SETTLEMENT.getCode() );
            ORDER_BY("b.create_time");
        }}.toString();
    }

}
