package com.clx.performance.service;

import com.clx.performance.model.OrderGoods;
import com.clx.performance.vo.feign.OrderExtractWeightVO;

import java.math.BigDecimal;

public interface OrderWeightService {
    OrderExtractWeightVO getOrderCanExtractWeight(String orderNo);

    BigDecimal getOrderResidueWeight(String orderNo);

    BigDecimal getAlreadyWeight(String orderNo);

    BigDecimal getAlreadyWeight(BigDecimal transportWeight, String orderNo);

    //计算货单真实的提取量
    BigDecimal calcOrderGoodsRealExtractWeight(OrderGoods item);
}
